---
title: Contents
order: 1
seoTitle: Tabler Emails - Content of the package
description: Content of the Tabler Emails package.
summary: The Tabler Emails package contains files which can be used by everyone, even without great knowledge of HTML.
seoDescription: todo
---

## Folder structure

Once you unzip the downloaded file, you will see the following structure:

```
tabler-emails/
├── emails/
|	├── absence/
|	|	├── assets/
|	|	├── compiled.html
|	|	├── compiled-dark.html
|	|	├── source.html
|	|	├── source-dark.html
|	|	├── screenshot.jpg
|	|	├── screenshot-dark.jpg
|	|	├── screenshot-mobile.jpg
|	|	└── screenshot-mobile-dark.jpg
|	├── access-token/
|	├── account-deleted/
|	├── .../
|	├── welcome/
|	└── whishlist/
├── images/
|	├── chart-donuts/
|	├── icons/
|	├── illustrations/
|	└── overlays/
├── license.txt
└── readme.html
```

## Understanding the file structure in Tabler Emails

The **Tabler Emails** package is organized into a clear and efficient folder structure to streamline the use of its assets. Below is a breakdown of its key directories:

### 1. Email Templates: `emails/`
This folder contains {{ emailsCount }} email subfolders, each with a specific template. Each email folder contains the following files:
* Compiled HTML files for light and dark themes. Read more about their usage in the [Compiled HTML](/emails/introduction/compiled-html) section.
* Source HTML files for light and dark themes. Find more information in the [Source HTML](/emails/introduction/source-html) section.
* Screenshot images for desktop and mobile views.
* Assets folder with images used in the email template and the CSS file with styles.

### 2. Images: `images/`
It contains 4 subfolders with images used across the different email templates:
* `chart-donuts/`: Images of donut charts with different fills.
* `icons/`: [Tabler Icons](/icons) used in the email templates, in PNG version.
* `illustrations/`: PNG versions of [Tabler Illustrations](/illustrations) for light and dark themes.
* `overlays/`: Overlay images used in the email templates.

### 3. License: `license.txt`
This file contains the license information for the Tabler Emails package.

### 4. Readme: `readme.html`
This file contains the main information about the Tabler Emails package, including a brief description and instructions on how to use it.

Do you like our templates? **Find out more and purchase on [our website]({{ site.homepage }}/emails)**.